<?php
if (!defined("ABSPATH")) exit;

add_action("rest_api_init", function () {
    register_rest_route("rwh/v1", "/paypack-webhook", [
        "methods" => "POST",
        "callback" => "rwh_paypack_webhook_handler",
        "permission_callback" => "__return_true"
    ]);
});

function rwh_paypack_webhook_handler($request) {
    global $wpdb;

    $data = $request->get_json_params();
    $resume_id = intval($_GET["resume_id"]);

    if ($data["status"] === "success") {
        $wpdb->update(
            $wpdb->prefix . "rwh_resumes",
            ["paid" => 1],
            ["id" => $resume_id],
            ["%d"],
            ["%d"]
        );
        return new WP_REST_Response(["message" => "Payment confirmed"], 200);
    }

    return new WP_REST_Response(["message" => "Payment failed"], 400);
}
