<?php
if (!defined("ABSPATH")) exit;

require_once plugin_dir_path(__FILE__) . "paypack-auth.php";

function rwh_start_payment() {
    global $wpdb;

    $phone = sanitize_text_field($_POST["phone"]);
    $resume_id = intval($_POST["resume_id"]);
    $amount = 2000;

    $token = rwh_paypack_get_token();
    if (!$token) wp_send_json_error(["message" => "PayPack auth failed"]);

    $response = wp_remote_post(PAYPACK_API_URL . "/transactions/cashin", [
        "headers" => [
            "Authorization" => "Bearer $token",
            "Content-Type" => "application/json"
        ],
        "body" => json_encode([
            "amount" => $amount,
            "number" => $phone,
            "callback_url" => PAYPACK_CALLBACK_URL . "?resume_id=$resume_id"
        ])
    ]);

    if (is_wp_error($response)) wp_send_json_error(["message" => "Payment request failed"]);

    $body = json_decode(wp_remote_retrieve_body($response), true);

    wp_send_json_success([
        "message" => "Payment initiated",
        "data" => $body
    ]);
}

add_action("wp_ajax_rwh_start_payment", "rwh_start_payment");
add_action("wp_ajax_nopriv_rwh_start_payment", "rwh_start_payment");
